import QtQuick 1.0
import org.kde.plasma.core 0.1 as PlasmaCore

Item {
    width: 600
    height: 400
    clip: true

    PlasmaCore.DataSource {
        id: rssSource
        dataEngine: "rss"
        interval: 0
        connectedSources: ["http://planetkde.org/rss20.xml"]
        onNewData: { listview.model = data["items"] }
    }

    Component {
        id : rssdelegate
        Column {
        spacing: 5
        Rectangle {
            width: listview.width
            height: authorView.height*2
            border.width: 3
            border.color: "white"
            color: "blue"
            radius: 4
            Text {
                anchors.left: parent.left
                anchors.leftMargin: 20
                anchors.verticalCenter: parent.verticalCenter
                id: authorView
                text: "Author:"+modelData["author"]
            }
        }
        Rectangle {
            width: listview.width
            height: bodyView.paintedHeight+40
            border.width: 3
            border.color: "white"
            color: "firebrick"
            radius: 4 
            Text {
                anchors.fill: parent
                anchors.margins: 20
                id: bodyView
                wrapMode: Text.Wrap
                text: "<body><div style=\"color: #ffffff\">"+modelData["description"]+"</div></body>"
            }
        }
        }
    }
    ListView {
        spacing: 20
        id: listview
        anchors.fill: parent
        delegate: rssdelegate
    }
}
